// default_shader.vsh

uniform mat4 vc0;	
uniform vec3 vc8;	// sun direction
uniform vec4 vc9;	// sun color
uniform vec4 vc10;	// ambient color
#ifdef TREE
uniform vec4 vc42;
uniform vec4 vc44;
uniform vec4 vc66;	// tree wind hack
#endif

void main()
{
#ifdef TREE
	// tree deformation
	vec4 r9;
    r9.x = gl_Vertex.x - vc66.y + vc42.w;
    r9.y = gl_Vertex.y;
    r9.z = gl_Vertex.z - vc66.z + vc44.w;
    r9.w = gl_Vertex.w;

    float r1x =  vc66.x * max(r9.x, r9.z);
	r1x *= 2.0;				// KLC -- Make tree swaying a little more obvious
    float r0y = sin(r1x);
	float r0x = cos(r1x);

	vec4 r5;
    r5.x = r0x;
    r5.y = 0.0;
    r5.z = -r0y;
    r5.w = vc66.y - vc42.w;

	vec4 r7;
    r7.x = r0y;
    r7.y = 0.0;
    r7.z = r0x;
    r7.w = vc66.z - vc44.w;

	vec4 r0;
    r0.x = dot(r9, r5);
    r0.y = gl_Vertex.y;
    r0.z = dot(r9, r7);
    r0.w = 1.0;
    
	vec3 r1;
    r1.x = dot(gl_Normal.xyz, r5.xyz);
    r1.y = gl_Normal.y;
    r1.z = dot(gl_Normal.xyz, r7.xyz);

	// transform position
	gl_Position = r0 * vc0;
	
	// normal dot light
	float intensity = max(dot(r1, vc8.xyz), 0.0);
#else
	// transform position
	gl_Position = gl_Vertex * vc0;
	
	// normal dot light
	float intensity = max(dot(gl_Normal.xyz, vc8.xyz), 0.0);
#endif
	
	// Calculate color
	vec4 clr = (vc9 * intensity) + vc10;
	clr.a = 1.0;
	clr = min(clr, 1.0);
	
	gl_FrontColor = clr;
	
	// Just copy texcoords
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
    gl_TexCoord[1].st = gl_MultiTexCoord0.st;
} 


/*

vs.1.1

def c20, 0, 1, 0.5, 2

dcl_position0 v0
dcl_normal0   v1
dcl_texcoord0 v2
#ifdef VERTEXCOLOR
dcl_color0	  v3
#endif
#ifdef CLIFF
dcl_texcoord2 v4
#endif

#ifdef TREE
   // Tell tree deformation snippet where the position and normal are.
   #define INPUT_POS v0
   #define INPUT_NORMAL v1
   
   // Deform.
   #include "tree_deform.vsh"
   
   // Outputs are in r0/r1
   #define POS r0
   #define NORMAL r1
#else
   // Not tree-deformed so just use unmodified pos/normal.
   #define POS v0
   #define NORMAL v1
#endif

// transform position
dp4 oPos.x, POS, c[0]
dp4 oPos.y, POS, c[1]
dp4 oPos.z, POS, c[2]
dp4 oPos.w, POS, c[3]

// normal dot light
dp3 r0.x, NORMAL, c8
max r0.x, r0.x, c20.x

#ifdef OVERALL_ALPHA
    // Set alpha to intrinsic value
	mov r0.w, c11.w
#else
	// Make alpha 1.0
	mov r0.w, c20.y
#endif

// Modulate with sun color
mul r0.xyz, c9.xyz, r0.x

// Add ambient color
add r0, r0, c10

#ifdef VERTEXCOLOR
// Modulate with vertex color
mul r0, r0, v3
#endif


#ifdef ENVMAP
   // Calculate eye vector and transform it into world space.  No need to normalize.
   sub r3, POS, c12

   dp3 r2.x, r3, c44
   dp3 r2.y, r3, c45
   dp3 r2.z, r3, c46
   mov r2.w, c20.y

   // Transform normal into world space and normalize
   dp3 r1.x, NORMAL, c44
   dp3 r1.y, NORMAL, c45
   dp3 r1.z, NORMAL, c46

   dp3 r1.w, r1, r1
   rsq r1.w, r1.w
   mul r1, r1, r1.w

   // Calculate the reflection vector (v = i - 2 * dot(i, n) * n)
   dp3 r1.w, r2, r1
   mul r1.xyz, r1.xyz, r1.w
   mul r1, r1, c20.w
   sub r1, r2, r1

   dp3 r1.w, r1, r1
   rsq r1.w, r1.w
   mul oT2, r1, r1.w
#endif


// Cap out at 1.0
min oD0, r0, c20.yyyy

// Use directly texcoord0
#ifdef CLIFF
   mov oT0.xy, v4
   mov oT1.xy, v4
#else
   mov oT0.xy, v2
   mov oT1.xy, v2
#endif
*/
